/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.solonion.client.gui.ItemListPage;
import team.creative.solonion.client.gui.elements.UIFoodQueueItem;
import team.creative.solonion.common.food.FoodPlayerDataImpl;

public final class FoodListPage
extends ItemListPage {
    private FoodListPage(Rectangle frame, String header, List<ItemStack> items, Player player) {
        super(frame, header, items);
        this.setHeaderTooltip(LanguageUtils.translate((String)"gui.solonion.food_book.food_queue_tooltip"));
        int minX = -40;
        int minY = -54;
        int i = 0;
        for (Tuple tuple : FoodPlayerDataImpl.calculateDiversityIndividualy(items, (LivingEntity)player)) {
            ItemStack itemStack = (ItemStack)tuple.key;
            int x = minX + 20 * (i % 5);
            int y = minY + 20 * (i / 5 % 6);
            UIFoodQueueItem view = new UIFoodQueueItem(itemStack, (Double)tuple.value, i);
            view.setCenterX(this.getCenterX() + x);
            view.setCenterY(this.getCenterY() + y);
            this.children.add(view);
            ++i;
        }
    }

    public static List<ItemListPage> pages(Rectangle frame, String header, List<ItemStack> items, Player player) {
        ArrayList<ItemListPage> pages = new ArrayList<ItemListPage>();
        for (int startIndex = 0; startIndex < items.size(); startIndex += 30) {
            int endIndex = Math.min(startIndex + 30, items.size());
            pages.add(new FoodListPage(frame, header, items.subList(startIndex, endIndex), player));
        }
        return pages;
    }
}

